package com.company.tp07_02_localtodoapp2.viewmodel;

import android.app.Application;

import androidx.annotation.NonNull;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.MutableLiveData;

import com.company.tp07_02_localtodoapp2.database.Todo;
import com.company.tp07_02_localtodoapp2.repository.TodoRepo;

import java.util.List;

public class TodoViewModel extends AndroidViewModel {

    private TodoRepo todoRepo;
    private MutableLiveData<List<Todo>> todoList;
    public TodoViewModel(@NonNull Application application) {
        super(application);
        todoRepo = TodoRepo.getInstance(application);
        todoList = todoRepo.getTodoList();
    }
    public MutableLiveData<List<Todo>> getTodoList() {
        return todoList;
    }

    public void insert(Todo todo) {
        todoRepo.insert(todo);
    }
}
